cmp.mapping(function(fallback)
  local line, col = unpack(vim.api.nvim_win_get_cursor(0))

  -- When the selection menu is open select the next item
  if cmp.visible() then
    cmp.select_next_item()
  -- Ensure we are mid word
  elseif col ~= 0 and vim.api.nvim_buf_get_lines(0, line - 1, line, true)[1]:sub(col, col):match("%s") == nil then
    -- Open the selection menu
    cmp.complete()
    -- Autocomplete when there is only 1 selection available
    if #cmp.get_entries() == 1 then
      cmp.confirm({ select = true })
    end
  -- Keep regular functionality of tab
  else
    fallback()
  end
end, {'i', 's'})
